StringVal="1e-5"
StringTask="read"
maxlen=512
#"RTE CoLA SST2 MRPC STSB QQP QNLI MNLI"
model_name="./results/finetune/google/electra-large-discriminator/read/lr-1e-5-seed-1-maxlen512"
config_name="google/electra-large-discriminator"
seeds="1"
for task in $StringTask; do
	for seed in $seeds; do
		for val in $StringVal; do 
		
			echo ${val}
			OutDir="results/finetune/${config_name}/${task}/lr-"
			OutDir+="${val}"
			OutDir+="-seed-${seed}-maxlen${maxlen}"
			mkdir -p "$OutDir"
			echo ${OutDir}
			CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:./src python ./src/finetune/run_read_no_trainer.py \
			--task_name ${task} \
			--model_name_or_path ${model_name}\
			--train_file ./data/commonlitreadabilityprize/train.csv \
			--validation_file ./data/commonlitreadabilityprize/validation.csv \
			--test_file ./data/commonlitreadabilityprize/test.csv \
			--do_predict \
			--do_eval \
			--learning_rate $val \
			--warmup_ratio 0.1 \
			--num_train_epochs 10 \
			--max_seq_length ${maxlen} \
			--output_dir $OutDir \
			--per_device_eval_batch_size=1 \
			--overwrite_output \
			--overwrite_cache \
			--seed ${seed}  #|& tee "results/finetune/${model_name}/${task}/${task}_lr${val}_seed${seed}.txt" -i
			#--eval_steps 12 \
			#--logging_steps 12 \
			#--config_name "bert-base-uncased" \
			#--tokenizer_name "bert-base-uncased" \
			#--evaluate_during_training
			#unc-nlp/
		done
	done
done
